<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-02-10 13:28
 */
interface LastbillidspricesupdatedDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Lastbillidspricesupdated 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param lastbillidspricesupdated primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Lastbillidspricesupdated lastbillidspricesupdated
 	 */
	public function insert($lastbillidspricesupdated);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Lastbillidspricesupdated lastbillidspricesupdated
 	 */
	public function update($lastbillidspricesupdated);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBuybill($value);

	public function queryByBuyandret($value);

	public function queryByRetbuy($value);

	public function queryBySell($value);

	public function queryBySellandret($value);

	public function queryByRetsell($value);


	public function deleteByBuybill($value);

	public function deleteByBuyandret($value);

	public function deleteByRetbuy($value);

	public function deleteBySell($value);

	public function deleteBySellandret($value);

	public function deleteByRetsell($value);


}
?>